<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
  <xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
  <xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
        <!-- Title displayed in browser Title Bar -->
        <title lang="en">Výpis Zaměření Tolerance</title>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <center>
                <!-- Report Title -->
                <h2 lang="en">Výpis Zaměření Tolerance</h2>
                <p lang="en">
                  Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                  Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                </p>
              </center>
              <xsl:for-each select="ToleranceReport">
                <!-- Header -->
                <xsl:for-each select="Header">
                  <table class="margin" cellpadding="2" width="80%">
                    <tbody>
                      <tr>
                        <th align="right"  lang="en">Projekt:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@name"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Polní zápisník:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@datasetName"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right" lang="en">Jednotky:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@surveyLinearUnits"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Směrová tolerance:&#xa0; </th>
                        <!--td align="left" colspan="2"><xsl:value-of select="@horizontalDistanceTolerance"/></td-->
                        <td align="left" colspan="2">
                          <xsl:value-of select="cif:distanceFormat(number(@horizontalDistanceTolerance))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Výšková tolerance:&#xa0; </th>
                        <!--td align="left" colspan="2"><xsl:value-of select="@verticalDistanceTolerance"/></td-->
                        <td align="left" colspan="2">
                          <xsl:value-of select="cif:ordinateFormat(number(@verticalDistanceTolerance))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Směrově vyrovnaný:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@isHorizontalAdjusted"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Výškově vyrovnaný:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@isVerticalAdjusted"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Vyrovnání uhlů:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@angleBalance"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Použít nastavení kolimace:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@useCollimation"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Kombinovaný koeficient měřítka:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@combinedScaleFactorOption"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Kombinovaný koeficient měřítka Globální:&#xa0; </th>
                        <!--td align="left" colspan="2"><xsl:value-of select="@combinedScaleFactorGlobal"/></td-->
                        <td align="left" colspan="2">
                          <xsl:value-of select="cif:formatNumber(number(@combinedScaleFactorGlobal),10)"/>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </xsl:for-each>
                <hr />
                <!-- Summary -->
                <xsl:for-each select="Summary">
                  <left>
                    <h3 lang="en">Shrnutí</h3>
                  </left>
                  <table class="margin" cellpadding="3" width="30%">
                    <tbody>
                      <tr>
                        <th align="right"  lang="en">Bodů celkem:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@pointCount"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Celkem nastavení:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@setupCount"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right" lang="en">Celkem měření:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@observationCount"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Nastavení se směrovou kolimací:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@setupWithHorizontalCollimationCount"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Nastavení s výškovou kolimací:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@setupWithVerticalCollimationCount"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Nastavení s kombinovaným koeficientem měřítka:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@setupWithScaleFactorCount"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Resekce Nastavení:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@resectionSetupCount"/>
                        </td>
                      </tr>
                      <tr>
                        <xsl:if test="@resectionHorizontalFailedCount!='0'">
                          <xsl:attribute name="style">color:FF0000</xsl:attribute>
                        </xsl:if>
                        <th align="right"  lang="en">Směrová resekce selhala:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@resectionHorizontalFailedCount"/>
                        </td>
                      </tr>
                      <tr>
                        <xsl:if test="@resectionVerticalFailedCount!='0'">
                          <xsl:attribute name="style">color:FF0000</xsl:attribute>
                        </xsl:if>
                        <th align="right"  lang="en">Výšková resekce selhala:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@resectionVerticalFailedCount"/>
                        </td>
                      </tr>
                      <tr>
                        <xsl:if test="@resectionInvalidCount!='0'">
                          <xsl:attribute name="style">color:FF0000</xsl:attribute>
                        </xsl:if>
                        <th align="right"  lang="en">Resekce s nedostatkem dat:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@resectionInvalidCount"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Řídící body:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@checkPointCount"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="right"  lang="en">Řídící body měření:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@checkPointObservationCount"/>
                        </td>
                      </tr>
                      <tr>
                        <xsl:if test="@checkPointHorizontalFailedCount!='0'">
                          <xsl:attribute name="style">color:FF0000</xsl:attribute>
                        </xsl:if>
                        <th align="right"  lang="en">Kontrola směrových bodů selhala:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@checkPointHorizontalFailedCount"/>
                        </td>
                      </tr>
                      <tr>
                        <xsl:if test="@checkPointVerticalFailedCount!='0'">
                          <xsl:attribute name="style">color:FF0000</xsl:attribute>
                        </xsl:if>
                        <th align="right"  lang="en">Kontrola výškových bodů selhala:&#xa0; </th>
                        <td align="left" colspan="2">
                          <xsl:value-of select="@checkPointVerticalFailedCount"/>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </xsl:for-each>
                <hr />
                <!-- SetupScaleFactors -->
                <xsl:for-each select="SetupScaleFactors">
                  <left>
                    <h3 lang="en">Koeficienty měřítka</h3>
                  </left>
                  <table class="margin" cellpadding="1" width="60%">
                    <tbody>
                      <xsl:for-each select="SetupScaleFactor">
                        <tr>
                          <td align="left" lang="en">
                            Použití koeficientu měřítka &#xa0;
                          </td>
                          <td align="left">
                            <xsl:value-of select="@combinedScaleFactor"/>
                          </td>
                          <td align="left" lang="en">
                            pro nastavení&#xa0;
                          </td>
                          <td align="left">
                            <xsl:value-of select="@setupName"/>
                          </td>
                          <td align="left" lang="en">
                            z důvodu volby&#xa0;
                          </td>
                          <td align="left">
                            <xsl:value-of select="@combinedScaleFactorOption"/>
                          </td>
                        </tr>
                      </xsl:for-each>
                    </tbody>
                  </table>
                </xsl:for-each>
                <hr />
                <!-- SetupCollimations -->
                <xsl:for-each select="SetupCollimations">
                  <left>
                    <h3 lang="en">Kolimace nastavení</h3>
                    <h4 lang="en">
                      Použít nastavení kolimace:&#xa0; <xsl:value-of select="@useCollimation"/>
                    </h4>
                  </left>
                  <xsl:choose>
                    <xsl:when test="@useCollimation='true'">
                      <table class="margin" cellpadding="2" cellspacing="2" width="30%">
                        <thead style="display:table-header-group">
                          <tr>
                            <th class="underline" lang="en" align="left">
                              Název<br/>Nastavení
                            </th>
                            <th class="underline" lang="en" align="right">
                              Směrová<br/>Kolimace
                            </th>
                            <th class="underline" lang="en" align="right">
                              Výšková<br/>Kolimace
                            </th>
                          </tr>
                        </thead>
                        <tbody>
                          <xsl:for-each select="SetupCollimation">
                            <tr>
                              <td align="left">
                                <xsl:value-of select="@setupName"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:angularFormat(number(@collimationHorizontal))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:angularFormat(number(@collimationVertical))"/>
                              </td>
                            </tr>
                          </xsl:for-each>
                        </tbody>
                      </table>
                    </xsl:when>
                  </xsl:choose>
                </xsl:for-each>
                <hr />
                <!-- Resections - Shot Observations and Tolerances-->
                <xsl:for-each select="Resections">
                  <left>
                    <h3 lang="en">Resekce Tolerance a Měření</h3>
                  </left>
                  <xsl:for-each select="Resection">
                    <left>
                      <h4 lang="en">
                        Název bodu resekce&#xa0; <xsl:value-of select="@name"/>
                      </h4>
                      <table class="margin" cellpadding="2" cellspacing="2" width="30%">
                        <thead style="display:table-header-group">
                          <tr>
                            <th class="underline" lang="en" align="right">
                              Severní<br/>Y
                            </th>
                            <th class="underline" lang="en" align="right">
                              Východní<br/>X
                            </th>
                            <th class="underline" lang="en" align="right">
                              Výška<br/>Z
                            </th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@pointNorthing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@pointEasting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@pointElevation))"/>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </left>
                    <!-- Resection Point Tolerances -->
                    <left>
                      <h5 lang="en">Resekce Bod Tolerance&#xa0;</h5>
                    </left>
                    <table class="margin" cellpadding="2" cellspacing="2" width="80%">
                      <thead style="display:table-header-group">
                        <tr>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Nastavení
                          </th>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Zpět
                          </th>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Měřený
                          </th>
                          <th class="underline" lang="en" align="right">
                            Bod<br/>
                          </th>
                          <th class="underline" lang="en" align="right">
                            Severní<br/>Y
                          </th>
                          <th class="underline" lang="en" align="right">
                            Východní<br/>X
                          </th>
                          <th class="underline" lang="en" align="right">
                            Výška<br/>Z
                          </th>
                          <th class="underline" lang="en" align="right">
                            Směrová<br/>vzdálenost
                          </th>
                          <th class="underline" lang="en" align="right">
                            Směr<br/>Směrník
                          </th>
                        </tr>
                      </thead>
                      <tbody>
                        <xsl:for-each select="ResectionShotResult">
                          <tr>
                            <td align="left">
                              <xsl:value-of select="@setupName"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="@backsightName"/>
                            </td>
                            <td align="left">
                              <xsl:if test="(@failsHorizontalDistanceTolerance='true' or @failsVerticalDistanceTolerance='true')">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>
                              </xsl:if>
                              <xsl:value-of select="@foresightName"/>
                            </td>
                            <td align="right" lang="en">Měřený:&#xa0;</td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@observationNorthing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@observationEasting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@observationElevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@observedDistanceFromSetup))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:directionFormat(number(@observedDirectionFromSetup))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" colspan="4" lang="en">Uložený:&#xa0;</td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@storedNorthing))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@storedEasting))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@storedElevation))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@storedDistanceFromSetup))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:directionFormat(number(@storedDirectionFromSetup))"/>
                            </td>
                          </tr>
                          <tr>
                            <xsl:choose>
                              <xsl:when test="(@failsHorizontalDistanceTolerance='true' or @failsVerticalDistanceTolerance='true')">
                                <td align="right" colspan="4" lang="en">
                                  <xsl:attribute name="style">color:FF0000</xsl:attribute>
                                  Rozdíly:&#xa0;
                                </td>
                              </xsl:when>
                              <xsl:otherwise>
                                <td align="right" colspan="4" lang="en">
                                  Rozdíly:&#xa0;
                                </td>
                              </xsl:otherwise>
                            </xsl:choose>
                            <td align="right">
                              <xsl:if test="@failsHorizontalDistanceTolerance='true'">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>
                              </xsl:if>
                              <xsl:value-of select="cif:distanceFormat(number(@differenceNorthing))"/>
                            </td>
                            <td align="right">
                              <xsl:if test="@failsHorizontalDistanceTolerance='true'">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>
                              </xsl:if>
                              (<xsl:value-of select="cif:distanceFormat(number(@differenceHorizontalDistance))"/>)&#xa0;&#xa0;<xsl:value-of select="cif:distanceFormat(number(@differenceEasting))"/>
                            </td>
                            <td align="right">
                              <xsl:if test="@failsVerticalDistanceTolerance='true'">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>
                              </xsl:if>
                              <xsl:value-of select="cif:distanceFormat(number(@differenceElevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@differenceDistanceFromSetup))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@differenceDirectionFromSetup))"/>
                            </td>
                            <xsl:if test="@failsHorizontalDistanceTolerance='true'">
                              <td align="center" colspan="4" lang="en">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>Směrová
                              </td>
                            </xsl:if>
                            <xsl:if test="@failsVerticalDistanceTolerance='true'">
                              <td align="center" colspan="4" lang="en">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>Výšková
                              </td>
                            </xsl:if>
                          </tr>
                          <tr>
                            <td align="right" colspan="9">&#xa0;</td>
                          </tr>
                        </xsl:for-each>
                      </tbody>
                    </table>
                    <!-- Resection Observation Tolerances -->
                    <left>
                      <h5 lang="en">Resekce Měření Tolerance &#xa0;</h5>
                    </left>
                    <table class="margin" cellpadding="2" cellspacing="2" width="80%">
                      <thead style="display:table-header-group">
                        <tr>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Nastavení
                          </th>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Zpět
                          </th>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Měřený
                          </th>
                          <th class="underline" lang="en" align="right">
                            Osazený<br/>Výška
                          </th>
                          <th class="underline" lang="en" align="right">
                            Tyč<br/>Výška
                          </th>
                          <th class="underline" lang="en" align="right">
                            Po oblouku<br/>Čtení
                          </th>
                          <th class="underline" lang="en" align="right">
                            Měření
                          </th>
                          <th class="underline" lang="en" align="right">
                            Směrový<br/>úhel
                          </th>
                          <th class="underline" lang="en" align="right">
                            Výškový<br/>úhel
                          </th>
                          <th class="underline" lang="en" align="right">
                            Šikmá<br/>Vzdálenost
                          </th>
                        </tr>
                      </thead>
                      <tbody>
                        <xsl:for-each select="ResectionShotResult">
                          <tr>
                            <td align="left">
                              <xsl:value-of select="@setupName"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="@backsightName"/>
                            </td>
                            <td align="left">
                              <xsl:if test="(@failsHorizontalDistanceTolerance='true' or @failsVerticalDistanceTolerance='true')">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>
                              </xsl:if>
                              <xsl:value-of select="@foresightName"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@occupyHeight))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@foresightHeight))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleCircleReading))"/>
                            </td>

                            <td align="right" lang="en">Čtení:&#xa0;</td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleHorizontal))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="@instrumentOrient"/>&#xa0;&#xa0;<xsl:value-of select="cif:angularFormat(number(@angleVertical))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@slopeDistance))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" colspan="7" lang="en">Kolimovaný nebo změna měřítka:&#xa0;</td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleHorizontalAdjustedCollimation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleVerticalAdjustedCollimation))"/>
                            </td>
                            <td align="right">
                              (<xsl:value-of select="cif:formatNumber(number(@slopeDistanceFactor),10)"/>)&#xa0;&#xa0;<xsl:value-of select="cif:distanceFormat(number(@slopeDistanceAdjustedScaleFactor))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" colspan="7" lang="en">Měřeno:&#xa0;</td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleHorizontalMeasured))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleVerticalMeasured))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@slopeDistanceMeasured))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" colspan="7" lang="en">Uloženo:&#xa0;</td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleHorizontalStored))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleVerticalStored))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@slopeDistanceStored))"/>
                            </td>
                          </tr>
                          <tr>
                            <xsl:if test="(@failsHorizontalDistanceTolerance='true' or @failsVerticalDistanceTolerance='true')">
                              <xsl:attribute name="style">color:FF0000</xsl:attribute>
                            </xsl:if>
                            <td align="right" colspan="7" lang="en">Rozdíly:&#xa0;</td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleHorizontalDifference))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleVerticalDifference))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@slopeDistanceDifference))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" colspan="10">&#xa0;</td>
                          </tr>
                        </xsl:for-each>
                      </tbody>
                    </table>
                    <hr />
                  </xsl:for-each>
                </xsl:for-each>
                <hr />
                <!-- Redundants - Shot Observations and Tolerances-->
                <xsl:for-each select="Redundants">
                  <left>
                    <h3 lang="en">Redundance Kontrolní Tolerance a Měření</h3>
                  </left>
                  <xsl:for-each select="Redundant">
                    <left>
                      <xsl:choose>
                        <xsl:when test="@isControlPoint='true'">
                          <h4 lang="en">
                            Název řídícího bodu:&#xa0; <xsl:value-of select="@name"/>
                          </h4>
                        </xsl:when>
                        <xsl:otherwise>
                          <h4 lang="en">
                            Název bodu:&#xa0; <xsl:value-of select="@name"/>
                          </h4>
                        </xsl:otherwise>
                      </xsl:choose>
                      <table class="margin" cellpadding="2" cellspacing="2" width="30%">
                        <thead style="display:table-header-group">
                          <tr>
                            <th class="underline" lang="en" align="right">
                              Severní<br/>Y
                            </th>
                            <th class="underline" lang="en" align="right">
                              Východní<br/>X
                            </th>
                            <th class="underline" lang="en" align="right">
                              Výška<br/>Z
                            </th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@pointNorthing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@pointEasting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@pointElevation))"/>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </left>
                    <!-- Redundant Point Tolerances -->
                    <left>
                      <h5 lang="en">Redundantní BodTolerance &#xa0;</h5>
                    </left>
                    <table class="margin" cellpadding="2" cellspacing="2" width="80%">
                      <thead style="display:table-header-group">
                        <tr>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Nastavení
                          </th>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Zpět
                          </th>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Obsazený
                          </th>
                          <th class="underline" lang="en" align="right">
                            Bod<br/> <xsl:value-of select="@name"/>
                          </th>
                          <th class="underline" lang="en" align="right">
                            Severní<br/>Y
                          </th>
                          <th class="underline" lang="en" align="right">
                            Východní<br/>X
                          </th>
                          <th class="underline" lang="en" align="right">
                            Výška<br/>Z
                          </th>
                          <th class="underline" lang="en" align="right">
                            Směrová<br/>vzdálenost<br/>z nastavení
                          </th>
                          <th class="underline" lang="en" align="right">
                            Směr<br/>Směrník<br/>z nastavení
                          </th>
                        </tr>
                      </thead>
                      <tbody>
                        <xsl:for-each select="RedundantShotResult">
                          <tr>
                            <td align="left">
                              <xsl:if test="(@failsHorizontalDistanceTolerance='true' or @failsVerticalDistanceTolerance='true')">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>
                              </xsl:if>
                              <xsl:value-of select="@setupName"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="@backsightName"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="@occupyName"/>
                            </td>
                            <td align="right" lang="en">Měřený:&#xa0;</td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@observationNorthing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@observationEasting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@observationElevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@observedDistanceFromSetup))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:directionFormat(number(@observedDirectionFromSetup))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" colspan="4" lang="en">Uloženo:&#xa0;</td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@storedNorthing))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@storedEasting))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@storedElevation))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@storedDistanceFromSetup))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:directionFormat(number(@storedDirectionFromSetup))"/>
                            </td>
                          </tr>
                          <tr>
                            <xsl:choose>
                              <xsl:when test="(@failsHorizontalDistanceTolerance='true' or @failsVerticalDistanceTolerance='true')">
                                <td align="right" colspan="4" lang="en">
                                  <xsl:attribute name="style">color:FF0000</xsl:attribute>
                                  Rozdíly:&#xa0;
                                </td>
                              </xsl:when>
                              <xsl:otherwise>
                                <td align="right" colspan="4" lang="en">
                                  Rozdíly:&#xa0;
                                </td>
                              </xsl:otherwise>
                            </xsl:choose>
                            <td align="right">
                              <xsl:if test="@failsHorizontalDistanceTolerance='true'">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>
                              </xsl:if>
                              <xsl:value-of select="cif:distanceFormat(number(@differenceNorthing))"/>
                            </td>
                            <td align="right">
                              <xsl:if test="@failsHorizontalDistanceTolerance='true'">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>
                              </xsl:if>
                              (<xsl:value-of select="cif:distanceFormat(number(@differenceHorizontalDistance))"/>)&#xa0;&#xa0;<xsl:value-of select="cif:distanceFormat(number(@differenceEasting))"/>
                            </td>
                            <td align="right">
                              <xsl:if test="@failsVerticalDistanceTolerance='true'">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>
                              </xsl:if>
                              <xsl:value-of select="cif:distanceFormat(number(@differenceElevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@differenceDistanceFromSetup))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@differenceDirectionFromSetup))"/>
                            </td>
                            <xsl:if test="@failsHorizontalDistanceTolerance='true'">
                              <td align="center" colspan="4" lang="en">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>Směrové
                              </td>
                            </xsl:if>
                            <xsl:if test="@failsVerticalDistanceTolerance='true'">
                              <td align="center" colspan="4" lang="en">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>Výškové
                              </td>
                            </xsl:if>
                          </tr>
                          <tr>
                            <td align="right" colspan="9">&#xa0;</td>
                          </tr>
                        </xsl:for-each>
                      </tbody>
                    </table>
                    <!-- Redundant Point Observation Tolerances -->
                    <left>
                      <h5 lang="en">Redundantní Bod Měření Tolerance&#xa0;</h5>
                    </left>
                    <table class="margin" cellpadding="2" cellspacing="2" width="80%">
                      <thead style="display:table-header-group">
                        <tr>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Nastavení
                          </th>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Zpět
                          </th>
                          <th class="underline" lang="en" align="left">
                            Název<br/>Obsazeno
                          </th>
                          <th class="underline" lang="en" align="right">
                            Obsazeno<br/>Výška
                          </th>
                          <th class="underline" lang="en" align="right">
                            Tyč<br/>Výška
                          </th>
                          <th class="underline" lang="en" align="right">
                            Po oblouku<br/>Čtení
                          </th>
                          <th class="underline" lang="en" align="right">
                            Měření
                          </th>
                          <th class="underline" lang="en" align="right">
                            Směrový<br/>úhel
                          </th>
                          <th class="underline" lang="en" align="right">
                            Výškový<br/>úhel
                          </th>
                          <th class="underline" lang="en" align="right">
                            Šikmá<br/>Vzdálenost
                          </th>
                        </tr>
                      </thead>
                      <tbody>
                        <xsl:for-each select="RedundantShotResult">
                          <tr>
                            <td align="left">
                              <xsl:if test="(@failsHorizontalDistanceTolerance='true' or @failsVerticalDistanceTolerance='true')">
                                <xsl:attribute name="style">color:FF0000</xsl:attribute>
                              </xsl:if>
                              <xsl:value-of select="@setupName"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="@backsightName"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="@occupyName"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@occupyHeight))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@foresightHeight))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleCircleReading))"/>
                            </td>
                            <td align="right" lang="en">Čtení:&#xa0;</td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleHorizontal))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="@instrumentOrient"/>&#xa0;&#xa0;<xsl:value-of select="cif:angularFormat(number(@angleVertical))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@slopeDistance))"/>
                            </td>                            
                          </tr>
                          <tr>
                            <td align="right" colspan="7" lang="en">Kolimováno nebo Změna měřítka:&#xa0;</td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleHorizontalAdjustedCollimation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleVerticalAdjustedCollimation))"/>
                            </td>
                            <td align="right">
                              (<xsl:value-of select="cif:formatNumber(number(@slopeDistanceFactor),10)"/>)&#xa0;&#xa0;<xsl:value-of select="cif:distanceFormat(number(@slopeDistanceAdjustedScaleFactor))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" colspan="7" lang="en">Měřeno:&#xa0;</td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleHorizontalMeasured))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleVerticalMeasured))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@slopeDistanceMeasured))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" colspan="7" lang="en">Uloženo:&#xa0;</td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleHorizontalStored))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleVerticalStored))"/>
                            </td>
                            <td class="underline" align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@slopeDistanceStored))"/>
                            </td>
                          </tr>
                          <tr>
                            <xsl:if test="(@failsHorizontalDistanceTolerance='true' or @failsVerticalDistanceTolerance='true')">
                              <xsl:attribute name="style">color:FF0000</xsl:attribute>
                            </xsl:if>
                            <td align="right" colspan="7" lang="en">Rozdíly:&#xa0;</td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleHorizontalDifference))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@angleVerticalDifference))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@slopeDistanceDifference))"/>
                            </td>
                          </tr>                          
                        </xsl:for-each>
                      </tbody>
                    </table>
                    <hr />
                  </xsl:for-each>
                </xsl:for-each>
                <hr />
              </xsl:for-each>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>
  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Poznámky</h4>
      <p class="normal1" lang="en">Pro tento výpis je potřeba mít nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje minimálně jedno z nastavení zaměření.</p>
      <p class="normal1">Pro nejlepší výsledek spusťte výpis z Kontroly tolerance před nebo po vyrovnání.</p>
      <p class="normal1">Po otevření Průzkumníka výpisů lze vybrat jiný výpis nastavení.</p>
      <p class="small" lang="en">
        <em>&#xa9; 2012 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
